#include "CompoundWords.h"
using namespace std;

Set<Vector<string>> splitsOf(string str) {
    (void) str;
    return {};
}

bool isCompoundWord(string word, Lexicon& english) {
    (void) word;
    (void) english;
    return false;
}

/* * * * * Test Cases Below This Point * * * * */
#include "GUI/SimpleTest.h"

PROVIDED_TEST("splitsOf works on RUBY and TOPAZ.") {
    EXPECT_EQUAL(splitsOf("RUBY"), {
                     {"R", "U", "B", "Y"},
                     {"R", "U", "BY"},
                     {"R", "UB", "Y"},
                     {"R", "UBY"},
                     {"RU", "B", "Y"},
                     {"RU", "BY"},
                     {"RUB", "Y"},
                     {"RUBY"}
                 });

    EXPECT_EQUAL(splitsOf("TOPAZ"), {
                     {"T", "O", "P", "A", "Z"},
                     {"T", "O", "P", "AZ"},
                     {"T", "O", "PA", "Z"},
                     {"T", "O", "PAZ"},
                     {"T", "OP", "A", "Z"},
                     {"T", "OP", "AZ"},
                     {"T", "OPA", "Z"},
                     {"T", "OPAZ"},
                     {"TO", "P", "A", "Z"},
                     {"TO", "P", "AZ"},
                     {"TO", "PA", "Z"},
                     {"TO", "PAZ"},
                     {"TOP", "A", "Z"},
                     {"TOP", "AZ"},
                     {"TOPA", "Z"},
                     {"TOPAZ"}
                 });
}

PROVIDED_TEST("isCompoundWord works on a restricted word list.") {
    Lexicon simple = { "abc", "ab", "bcd", "c", "cde", "def", "d", "ef", "efg", "abcdefg"};

    EXPECT(!isCompoundWord("a", simple));
    EXPECT(!isCompoundWord("ab", simple));
    EXPECT( isCompoundWord("abc", simple));
    EXPECT(!isCompoundWord("abcd", simple));
    EXPECT(!isCompoundWord("abcde", simple));
    EXPECT(!isCompoundWord("abcdef", simple));
    EXPECT( isCompoundWord("abcdefg", simple));
}

PROVIDED_TEST("isCompoundWord works on the full Lexicon.") {
    Lexicon english("res/EnglishWords.txt");

    EXPECT(!isCompoundWord("chrysanthemum", english));
    EXPECT( isCompoundWord("doorbell", english));
    EXPECT( isCompoundWord("heretofore", english));
}
