// Author: Sean Szumlanski
// Date: Summer 2025
//
// A basic weighted graph class with implementations of topological sort and
// Dijkstra's algorithm.
//
// This file is sparsely commented because we talked about the class members
// and overall structure/functionality of this class in lecture. For
// implementation details, see comments in weightedgraph.cpp.


#ifndef WEIGHTEDGRAPH_H
#define WEIGHTEDGRAPH_H

#include "grid.h"
#include "map.h"
#include "vector.h"
#include <string>

const int oo = 1e9;

class WeightedGraph
{
public:
    WeightedGraph(std::string filename);
    ~WeightedGraph();
    void printShortestPathsDijkstra(std::string startNodeLabel);
    void printPath(int i, Vector<int> origin);
    void printTopologicalSort();

private:
    Grid<int> _matrix;
    Vector<std::string> _labels;
    int _numNodes;
    Map<std::string, int> _labelToIndexMap;
};

#endif // WEIGHTEDGRAPH_H
