#include "Nodes.h"
#include "set.h"
using namespace std;

Set<Node*> trimAbove(Node* root, int level) {
    (void) root;
    (void) level;
    return {};
}

/* * * * * Test Cases Below This Point * * * * */
#include "GUI/SimpleTest.h"

PROVIDED_TEST("Level 0, tree from handout") {
    // Level 0
    Node* root = new Node;
    root->value = 6;

    // Level 1
    Node* nine = new Node;
    nine->value = 9;
    Node* one = new Node;
    one->value = 1;

    root->left = nine;
    root->right = one;

    // Level 2
    Node* three = new Node;
    three->value = 3;
    Node* five = new Node;
    five->value = 5;
    Node* seven = new Node;
    seven->value = 7;
    Node* zero = new Node;
    zero->value = 0;

    nine->left = three;
    nine->right = five;

    one->left = seven;
    one->right = zero;

    // Level 3
    Node* eight = new Node;
    eight->value = 8;
    Node* two = new Node;
    two->value = 2;
    Node* four = new Node;
    four->value = 4;

    three->left = eight;
    five->right = two;
    seven->left = four;

    EXPECT_EQUAL(trimAbove(root, 0), { root });

    freeTree(root);
}

PROVIDED_TEST("Level 1, tree from handout") {
    // Level 0
    Node* root = new Node;
    root->value = 6;

    // Level 1
    Node* nine = new Node;
    nine->value = 9;
    Node* one = new Node;
    one->value = 1;

    root->left = nine;
    root->right = one;

    // Level 2
    Node* three = new Node;
    three->value = 3;
    Node* five = new Node;
    five->value = 5;
    Node* seven = new Node;
    seven->value = 7;
    Node* zero = new Node;
    zero->value = 0;

    nine->left = three;
    nine->right = five;

    one->left = seven;
    one->right = zero;

    // Level 3
    Node* eight = new Node;
    eight->value = 8;
    Node* two = new Node;
    two->value = 2;
    Node* four = new Node;
    four->value = 4;

    three->left = eight;
    five->right = two;
    seven->left = four;

    EXPECT_EQUAL(trimAbove(root, 1), { nine, one });

    freeTree(nine);
    freeTree(one);
}

PROVIDED_TEST("Level 2, tree from handout") {
    // Level 0
    Node* root = new Node;
    root->value = 6;

    // Level 1
    Node* nine = new Node;
    nine->value = 9;
    Node* one = new Node;
    one->value = 1;

    root->left = nine;
    root->right = one;

    // Level 2
    Node* three = new Node;
    three->value = 3;
    Node* five = new Node;
    five->value = 5;
    Node* seven = new Node;
    seven->value = 7;
    Node* zero = new Node;
    zero->value = 0;

    nine->left = three;
    nine->right = five;

    one->left = seven;
    one->right = zero;

    // Level 3
    Node* eight = new Node;
    eight->value = 8;
    Node* two = new Node;
    two->value = 2;
    Node* four = new Node;
    four->value = 4;

    three->left = eight;
    five->right = two;
    seven->left = four;

    EXPECT_EQUAL(trimAbove(root, 2), { three, five, seven, zero });

    freeTree(three);
    freeTree(five);
    freeTree(seven);
    freeTree(zero);
}
PROVIDED_TEST("Level 3, tree from handout") {
    // Level 0
    Node* root = new Node;
    root->value = 6;

    // Level 1
    Node* nine = new Node;
    nine->value = 9;
    Node* one = new Node;
    one->value = 1;

    root->left = nine;
    root->right = one;

    // Level 2
    Node* three = new Node;
    three->value = 3;
    Node* five = new Node;
    five->value = 5;
    Node* seven = new Node;
    seven->value = 7;
    Node* zero = new Node;
    zero->value = 0;

    nine->left = three;
    nine->right = five;

    one->left = seven;
    one->right = zero;

    // Level 3
    Node* eight = new Node;
    eight->value = 8;
    Node* two = new Node;
    two->value = 2;
    Node* four = new Node;
    four->value = 4;

    three->left = eight;
    five->right = two;
    seven->left = four;

    EXPECT_EQUAL(trimAbove(root, 3), { eight, two, four });

    freeTree(eight);
    freeTree(two);
    freeTree(four);
}

