#include "DominoChaining.h"
using namespace std;

bool canChainDominoes(Vector<Domino>& dominoes) {
    (void) dominoes;
    return false;
}

/* * * * * Test Cases Below This Point * * * * */
#include "GUI/SimpleTest.h"

PROVIDED_TEST("Can chain zero or one domino.") {
    Vector<Domino> empty = {};
    Vector<Domino> one = { { 1, 3 } };
    EXPECT(canChainDominoes(empty));
    EXPECT(canChainDominoes(one));
}

PROVIDED_TEST("Works given two dominoes") {
    /* No solution */
    Vector<Domino> nosoln1 = { { 1, 2 }, { 3, 4 } };
    EXPECT(!canChainDominoes(nosoln1));

    Vector<Domino> nosoln2 = { { 2, 1 }, { 3, 4 } };
    EXPECT(!canChainDominoes(nosoln2));

    Vector<Domino> nosoln3 = { { 1, 2 }, { 4, 3 } };
    EXPECT(!canChainDominoes(nosoln3));

    Vector<Domino> nosoln4 = { { 2, 1 }, { 4, 3 } };
    EXPECT(!canChainDominoes(nosoln4));

    /* Solution exists. */
    Vector<Domino> soln1 = { { 1, 2 }, { 2, 3 } };
    EXPECT(canChainDominoes(soln1));

    Vector<Domino> soln2 = { { 2, 1 }, { 2, 3 } };
    EXPECT(canChainDominoes(soln2));

    Vector<Domino> soln3 = { { 1, 2 }, { 3, 2 } };
    EXPECT(canChainDominoes(soln3));

    Vector<Domino> soln4 = { { 2, 1 }, { 3, 2 } };
    EXPECT(canChainDominoes(soln4));
}

PROVIDED_TEST("Works for the example in the problem statement.") {
    Vector<Domino> d = {
        { 2, 6 },
        { 4, 1 },
        { 6, 5 },
        { 1, 5 },
        { 1, 3 },
        { 9, 5 },
        { 2, 9 },
        { 4, 1 }
    };
    EXPECT(canChainDominoes(d));
}

/* * * * * Implementation of Domino helper functions. * * * * */
bool operator== (const Domino& lhs, const Domino& rhs) {
    /* Both orientation work. */
    return (lhs.first == rhs.first  && lhs.second == rhs.second) ||
           (lhs.first == rhs.second && lhs.second == rhs.first);
}

bool operator!= (const Domino& lhs, const Domino& rhs) {
    return !(lhs == rhs);
}

bool operator<  (const Domino& lhs, const Domino& rhs) {
    /* Get them into canonical order. */
    Domino one = lhs, two = rhs;
    if (one.first > one.second) swap(one.first, one.second);
    if (two.first > two.second) swap(two.first, two.second);

    /* Now go lexicographically. */
    if (one.first != two.first) return one.first < two.first;
    return one.second < two.second;
}

ostream& operator<< (ostream& out, const Domino& d) {
    ostringstream builder;
    builder << "{ " << d.first << ", " << d.second << " }";
    return out << builder.str();
}
