#include "BackupVector.h"
using namespace std;

/* Initial size of the large array. (The small array is not allocated until
 * the large array is full.)
 */
const int kInitialSize = 2;

BackupVector::BackupVector() {
    /* TODO: Delete this comment, then implement this function. */
}

BackupVector::~BackupVector() {
    /* TODO: Delete this comment, then implement this function. */
}

void BackupVector::append(int toAdd) {
    /* TODO: Delete this comment and the next line, then implement this function. */
    (void) toAdd;
}

int BackupVector::get(int index) const {
    /* TODO: Delete this comment and the next lines, then implement this function. */
    (void) index;
    return { };
}

int BackupVector::size() const {
    /* TODO: Delete this comment and the next line, then implement this function. */
    return 0;
}

bool BackupVector::isEmpty() const {
    /* TODO: Delete this comment and the next line, then implement this function. */
    return false;
}

/* * * * * Test Cases Below This Point * * * * */
#include "GUI/SimpleTest.h"

PROVIDED_TEST("Grows from size 0 to size 5.") {
    /* Small: (null)
     * Large: _ _
     */
    BackupVector v;
    EXPECT_EQUAL(v.small, nullptr);
    EXPECT_NOT_EQUAL(v.large, nullptr);

    EXPECT(v.isEmpty());
    EXPECT_EQUAL(v.size(), 0);

    /* Small: (null)
     * Large: 0 1
     */
    v.append(0);
    v.append(1);
    EXPECT_EQUAL(v.large[0], 0);
    EXPECT_EQUAL(v.large[1], 1);

    int* oldLarge = v.large;

    /* Small: 0 ?
     * Large: _ 1 2 _
     */
    v.append(2);

    /* Confirm the small/large pointers changed. */
    EXPECT_EQUAL(v.small, oldLarge);
    EXPECT_NOT_EQUAL(v.large, oldLarge);

    /* Confirm values are there. */
    EXPECT_EQUAL(v.small[0], 0);
    EXPECT_EQUAL(v.large[1], 1);
    EXPECT_EQUAL(v.large[2], 2);

    /* Small: ? ?
     * Large: 0 1 2 3
     */
    int* oldSmall = v.small;
    oldLarge = v.large;

    v.append(3);

    /* No new allocations / deallocations should have happened. */
    EXPECT_EQUAL(v.small, oldSmall);
    EXPECT_EQUAL(v.large, oldLarge);

    /* Confirm values are there. */
    EXPECT_EQUAL(v.large[0], 0);
    EXPECT_EQUAL(v.large[1], 1);
    EXPECT_EQUAL(v.large[2], 2);
    EXPECT_EQUAL(v.large[3], 3);

    oldSmall = v.small;
    oldLarge = v.large;
    v.append(4);

    /* Small: 0 1 2 ?
     * Large: _ _ _ 3 4 _ _ _
     */
    EXPECT_EQUAL(v.small, oldLarge);
    EXPECT_NOT_EQUAL(v.large, oldLarge);

    EXPECT_EQUAL(v.small[0], 0);
    EXPECT_EQUAL(v.small[1], 1);
    EXPECT_EQUAL(v.small[2], 2);
    EXPECT_EQUAL(v.large[3], 3);
    EXPECT_EQUAL(v.large[4], 4);
}

PROVIDED_TEST("Lookups work after a small series appends.") {
    BackupVector v;

    const int kNumItems = 10;

    for (int i = 0; i < kNumItems; i++) {
        v.append(i);
    }

    EXPECT_EQUAL(v.size(), kNumItems);

    for (int i = 0; i < kNumItems; i++) {
        EXPECT_EQUAL(v.get(i), i);
    }
}

PROVIDED_TEST("Handles out-of-range lookups.") {
    BackupVector v;

    EXPECT_ERROR(v.get(0));
    EXPECT_ERROR(v.get(-1));
    EXPECT_ERROR(v.get(137));

    v.append(0);
    v.append(1);
    v.append(2);

    EXPECT_ERROR(v.get(-1));
    EXPECT_ERROR(v.get(137));
}

PROVIDED_TEST("Stress test: Can perform 1,000,000 appends and lookups (should take at most half a second).") {
    BackupVector v;
    const int kNumItems = 1000000;


    EXPECT_COMPLETES_IN(0.5,
        for (int i = 0; i < kNumItems; i++) {
            v.append(i);
        }

        EXPECT_EQUAL(v.size(), kNumItems);

        for (int i = 0; i < kNumItems; i++) {
            EXPECT_EQUAL(v.get(i), i);
        }
    );
}
