#include "RingBufferQueue.h"
#include "SimpleTest.h"

using namespace std;

const int kDefaultCapacity = 5;

RBQueue::RBQueue() {
    _capacity = kDefaultCapacity;
    _elements = new int[_capacity];
    _head = 0;
    _numUsed = 0;
}


RBQueue::~RBQueue() {
    delete[] _elements;

}

// TODO: Update enqueue to enlarge when queue is full
void RBQueue::enqueue(int elem) {
    if (isFull()) {
        error("Can't enqueue to already full queue!");
    }
    int tail = (_head + _numUsed) % _capacity;
    _elements[tail] = elem;
    _numUsed++;
}


int RBQueue::dequeue() {
    if (isEmpty()) {
        error("Can't dequeue from an empty queue!");
    }
	
    int front = _elements[_head];
    _head = (_head + 1) % _capacity;
    _numUsed--;
    return front;
}


int RBQueue::peek() const {
    if (isEmpty()) {
        error("Can't peek from an empty queue!");
    }
    return _elements[_head];
}


bool RBQueue::isEmpty() const {
    return _numUsed == 0;
}


bool RBQueue::isFull() const {
    return _numUsed == _capacity;
}


int RBQueue::size() const {
    return _numUsed;
}


/* Provided Tests Below This Line */

PROVIDED_TEST("Simple Example From Handout, No resizing") {
    RBQueue q;
    q.enqueue(1);
    q.enqueue(2);
    q.enqueue(3);
    EXPECT_EQUAL(q.peek(), 1);
    q.enqueue(4);
    q.enqueue(5);
    EXPECT(q.isFull());
    EXPECT_EQUAL(q.dequeue(), 1);
    EXPECT_EQUAL(q.dequeue(), 2);
    EXPECT_EQUAL(q.peek(), 3);
    q.enqueue(6);
    EXPECT_EQUAL(q.dequeue(), 3);
    EXPECT_EQUAL(q.dequeue(), 4);
    EXPECT_EQUAL(q.dequeue(), 5);
    EXPECT_EQUAL(q.dequeue(), 6);
    EXPECT(q.isEmpty());
}

PROVIDED_TEST("Example from Handout, with Resizing") {
    RBQueue q;
    for (int i = 10; i <= 50; i+= 10) {
        q.enqueue(i);
    }
    EXPECT(q.isFull());
    // Adding the 6th element should trigger a resizing
    q.enqueue(60);
    EXPECT(!q.isFull());
    for (int i = 10; i <= 60; i += 10) {
        EXPECT_EQUAL(i, q.peek());
        EXPECT_EQUAL(i, q.dequeue());
    }
    EXPECT(q.isEmpty());
}
