/**
 * This program contains code for various sorting algorithms
 * including insertion sort, selection sort,
 * and recursive merge sort.
 */

#include <fstream>
#include <iomanip>
#include <iostream>
#include "console.h"
#include "simpio.h"
#include "filelib.h"
#include "random.h"
#include "vector.h"
#include "timer.h"
#include "utility.h"
#include "SimpleTest.h"

using namespace std;

// function prototype declarations
int indexOfSmallest(const Vector<int>& elems, int startPoint);
void selectionSort(Vector<int>& v);
void mergeSort(Vector<int>& v);
void split(Vector<int>& vec, Vector<int>& left, Vector<int>& right);
void merge(Vector<int>& vec, Vector<int>& v1, Vector<int>& v2);
void swap(Vector<int>& v, int i, int j);

void selectionSort(Vector<int>& elems) {
    // TODO
}

int indexOfSmallest(const Vector<int>& elems, int startPoint) {
    int smallestIndex = startPoint;
    for (int i = startPoint + 1; i < elems.size(); i++) {
        if (elems[i] < elems[smallestIndex]) {
            smallestIndex = i;
        }
    }
    return smallestIndex;
}

void mergeSort(Vector<int>& vec) {
    // TODO
}

/*
 * Given a sequence of n elements (vec), splits the sequence into two sublists
 * each of size n/2 and stores these sublists in the output parameters left and
 * right.
 */
void split(Vector<int>& vec, Vector<int>& left, Vector<int>& right){
    int n = vec.size();
    left = vec.subList(0, n / 2);
    right = vec.subList(n / 2);
}

/*
 * Merges the sorted sequences v1 and v2 into one large, sorted result.
 * Precondition: v1 and v2 are sorted, and vec is empty
 */
void merge(Vector<int>& vec, Vector<int>& v1, Vector<int>& v2) {
    int n1 = v1.size();
    int n2 = v2.size();
    int idx1 = 0;
    int idx2 = 0;
    /*
     * While both lists still have at least one element in them, compare the
     * smallest remaining value in each and take the smaller of the two to add
     * onto the result list.
     */
    while (idx1 < n1 && idx2 < n2) {
        if (v1[idx1] < v2[idx2]) {
            vec.add(v1[idx1]);
            idx1++;
        } else {
            vec.add(v2[idx2]);
            idx2++;
        }
    }

    /*
     * Add in any remaining/leftover elements that didn't get caught by the above
     * loop.
     */
    while (idx1 < n1) {
        vec.add(v1[idx1]);
        idx1++;
    }

    while (idx2 < n2) {
        vec.add(v2[idx2]);
        idx2++;
    }
}


PROVIDED_TEST("Simple test to test correctness of overall selection sort algorithm"){
    Vector<int> vals;
    Vector<int> soln;
    fillRandomIntVector(vals, 10);
    soln = vals;

    /* Run selection sort algorithm. */
    selectionSort(vals);
    /* Use built-in sort funciton for solution */
    soln.sort();

    EXPECT_EQUAL(vals, soln);
}

PROVIDED_TEST("Timing Test for Selection Sort"){
    int startSize = 5000;
    for (int size = startSize; size <= 10 * startSize; size *= 2){
        Vector<int> vals;
        fillRandomIntVector(vals, size);
        TIME_OPERATION(size, selectionSort(vals));
    }
}

PROVIDED_TEST("Simple test to test correctness of split helper function."){
    Vector<int> vals = {1, 2, 3, 4, 5, 6};
    Vector<int> left, right;
    split(vals, left, right);
    EXPECT_EQUAL(left, vals.subList(0, 3));
    EXPECT_EQUAL(right, vals.subList(3, 3));
}

PROVIDED_TEST("Simple test to test correctness of merge helper function."){
    Vector<int> v1 = {1, 5, 7};
    Vector<int> v2 = {4, 6, 10, 12, 14};
    Vector<int> result;
    merge(result, v1, v2);
    Vector<int> soln = {1, 4, 5, 6, 7, 10, 12, 14};
    EXPECT_EQUAL(result, soln);
}

PROVIDED_TEST("Simple test to test correctness of overall merge sort algorithm"){
    Vector<int> vals;
    Vector<int> soln;
    fillRandomIntVector(vals, 10);
    soln = vals;

    /* Run insertion sort algorithm. */
    mergeSort(vals);
    /* Use built-in sort funciton for solution */
    soln.sort();

    EXPECT_EQUAL(vals, soln);
}

PROVIDED_TEST("Timing Test for Merge Sort"){
    int startSize = 50000;
    for (int size = startSize; size <= 10 * startSize; size *= 2){
        Vector<int> vals;
        fillRandomIntVector(vals, size);
        TIME_OPERATION(size, mergeSort(vals));
    }
}
