#include "tree.h"
#include "console.h"
#include "simpio.h"
#include "queue.h"
#include <iostream>
using namespace std;

TreeNode* buildExampleTree() {
    return nullptr;
}

void preOrderTraversal(TreeNode* tree) {
    // 1. "Do something" with the current node
    // 2. Traverse the left subtree
    // 3. Traverse the right subtree
}

void inOrderTraversal(TreeNode* tree) {
    // 1. Traverse the left subtree
    // 2. "Do something" with the current node
    // 3. Traverse the right subtree
}

void postOrderTraversal(TreeNode* tree) {
    // 1. Traverse the left subtree
    // 2. Traverse the right subtree
    // 3. "Do something" with the current node
}





// Level-order traversal
void levelOrder(TreeNode*tree) {
    Queue<TreeNode *>treeQueue;
    treeQueue.enqueue(tree);
    while (!treeQueue.isEmpty()) {
        TreeNode *node = treeQueue.dequeue();
        cout << node->data << " ";

        // enqueue both left and right, if they exist
        if (node->left != nullptr) {
            treeQueue.enqueue(node->left);
        }
        if (node->right != nullptr) {
            treeQueue.enqueue(node->right);
        }
    }
}

// All functions below this are to help with printing the tree
void printChars(int n, char c)
{
    for (int i = 0; i < n; i++) {
        cout << c;
    }
}

string padString(string s, int len) {
    // make the string len long
    int sLen = s.length();
    if ((len - sLen) % 2 == 1) {
        s += " ";
        sLen++;
    }
    for (int i = 0; i < (len - sLen) / 2; i++) {
        s = string(" ") + s + " ";
    }
    return s;
}

int treeHeight(TreeNode* tree) {
    if (tree == nullptr) {
        return 0;
    }
    int leftHeight = treeHeight(tree->left);
    int rightHeight = treeHeight(tree->right);
    if (leftHeight > rightHeight) {
        return leftHeight + 1;
    } else {
        return rightHeight + 1;
    }
}

int longestData(TreeNode* tree) {
    if (tree == nullptr) return 0;
    int longest = max(longestData(tree->left),
                      longestData(tree->right));
    return (max((int)tree->data.length(), longest));
}

void prettyPrint(TreeNode* tree)
{
    // calculate levels
    int numLevels = treeHeight(tree);
    int maxLength = longestData(tree);

    // go through each level and mark locations of numbers
    Queue<TreeNode*> q;
    q.enqueue(tree);
    int level = 0;
    int numberCount = 1 << level;
    int nextNumberOfCount = 0;
    int spacesSoFar = 0;
    while (!q.isEmpty()) {
        TreeNode* curr = q.dequeue();
        //             xxx
        //     xxx             xxx
        // xxx     xxx     xxx     xxx
        int first = (1 << (numLevels - level - 1)) - 1;
        int elementMult = 1 << (numLevels - level);
        int nextPos = (first + (nextNumberOfCount * elementMult)) * maxLength;

        printChars(nextPos - spacesSoFar, ' ');
        spacesSoFar = nextPos;
        if (curr != nullptr) {
            cout << padString(curr->data, maxLength);
        } else {
            printChars(maxLength, '-');
        }
        spacesSoFar += maxLength;
        if (curr != nullptr) {
            q.enqueue(curr->left);
            q.enqueue(curr->right);
        } else {
            q.enqueue(nullptr);
            q.enqueue(nullptr);
        }
        nextNumberOfCount++;
        if (nextNumberOfCount == numberCount) {
            nextNumberOfCount = 0;
            level++;
            numberCount = 1 << level;
            spacesSoFar = 0;
            if (level == numLevels) break; // don't print last level, which will be empty
            cout << endl;
        }
    }
    cout << endl;
}
