#include <iostream>
#include "console.h"
#include "strlib.h"
#include "testing/SimpleTest.h"
#include "RandomBag.h"
#include "BankAccount.h"

using namespace std;

/* Prints out how many items are in the bag. Note that we have to mark the
 * RandomBag::size() member function const for this to work, since otherwise
 * C++ won't know that member function doesn't mutate the bag.
 */
void printBagSize(const RandomBag& bag) {
    cout << "The bag has " << bag.size() << " things in it." << endl;
}

void randomBagDemo() {
    /* Some sample code using the RandomBag. */
    RandomBag bag;

    for (int i = 0; i < 10; i++) {
        bag.add(i);
    }

    printBagSize(bag);

    while (!bag.isEmpty()) {
        cout << "Removing " << bag.removeRandom() << endl;
    }

    printBagSize(bag);

}

struct BankAccountStruct {
    string name;
    double amount;
};

void bankDemoStructs(){
    BankAccountStruct amrita = {"Amrita", 100};
    BankAccountStruct elyse = {"Elyse", 1000};

    /* Amrita gets a paycheck and deposits it. */
    amrita.amount += 500;

    /* Elyse buys a new cat tree for Sidibou. */
    elyse.amount -= 900;

    /* Amrita wants to travel to the Galapagos to see turtles */
    amrita.amount -= 2000;
    /* This is BAD! Amrita doesn't have enough money to do this. */

    /* Amrita wants to transfer some money to Elyse for lunch. */
    elyse.amount += 20;
    /* This is BAD! The money appeared out of nowhere! */

    /* Amrita tries to commit identity fraud. */
    amrita.name = "Elyse";
    /* This is BAD! We shouldn't be able to do this! */

    cout << amrita.name << " " << amrita.amount << endl;
    cout << elyse.name << " " << elyse.amount << endl;

}

void bankDemoClasses(){
    BankAccount amrita("Amrita", 100);
    BankAccount elyse("Elyse", 1000);

    /* Amrita gets a paycheck and deposits it. */
    amrita.deposit(500);

    /* Elyse buys a new cat tree for Sidibou. */
    elyse.withdraw(900);

    /* Amrita wants to travel to the Galapagos to see turtles. */
    // amrita.withdraw(2000); // This now throws an error!

    /* Amrita wants to transfer some money to Elyse for lunch. */
    amrita.transfer(20, elyse);

    /* Amrita tries to commit identity fraud. */
    // amrita.name = "Elyse"; // This line won't compile!

    cout << amrita.getName() << " " << amrita.getAmount() << endl;
    cout << elyse.getName() << " " << elyse.getAmount() << endl;
}

int main() {

    randomBagDemo();
//    bankDemoStructs();
//    bankDemoClasses();

    return 0;
}
