const HOST = "http://localhost:8080/"

class ChatClient {
	constructor() {
		this.msgIndex = 0
		this.username = ""
	}

	getMessageHtml(msg) {
		return `<li class="list-group-item"> > ${msg}</li>`
	}

	async loadMessages() {
		const url = new URL(HOST + "getMsgs")
		url.searchParams.append("index", this.msgIndex)

		try {
			const response = await fetch(url)
			if (!response.ok) throw new Error("Failed to fetch messages.")
			const text = await response.text()
			this.renderMessages(text)
		} catch (err) {
			console.error("Error loading messages:", err)
		}
	}

	renderMessages(msgString) {
		if (!msgString) return
		const messages = eval(msgString)
		for (let i = 0; i < messages.length; i++) {
			const msg = messages[i]
			const msgHtml = this.getMessageHtml(msg)
			document.querySelector("#messages").insertAdjacentHTML("beforeend", msgHtml)
		}
		this.msgIndex += messages.length
	}

	refreshMessages() {
		this.loadMessages()
	}

	async sendMessage() {
		const msgInput = document.querySelector("#msgInput")
		const url = new URL(HOST + "newMsg")
		url.searchParams.append("msg", msgInput.value)
		url.searchParams.append("user", this.username)

		try {
			const response = await fetch(url)
			if (!response.ok) throw new Error("Failed to send message.")
			await this.loadMessages()
		} catch (err) {
			console.error("Error sending message:", err)
		}

		msgInput.value = ''
	}

	logIn() {
		const usernameInput = document.querySelector("#usernameInput")
		this.username = usernameInput.value.trim()
		if (this.username !== "") {
			document.querySelector("#loginModal").style.display = "none"
			this.loadMessages()
		}
	}
}

// global so buttons can access
let client

document.addEventListener("DOMContentLoaded", () => {
	client = new ChatClient()

	// Show modal
	const modal = document.querySelector("#loginModal")
	modal.style.display = "flex"
	document.querySelector("#usernameInput").focus()

	// Handle Enter key in login input
	document.querySelector("#usernameInput").addEventListener("keyup", (e) => {
		if (e.key === "Enter") {
			client.logIn()
		}
	})

	// Handle Enter key in message input
	document.querySelector("#msgInput").addEventListener("keyup", (e) => {
		if (e.key === "Enter") {
			client.sendMessage()
		}
	})
})

