"""
File: student.py
------------------------
Defines the Student class.
"""

UNITS_TO_GRADUATE = 180

class Student:

    def __init__(self, student_name, student_id):
        """
        Constructor for the Student class.
        Someone would invoke this constructor as follows:
                student1 = Student("Paul", 10384709384)
        """
        self.student_name = student_name
        self.student_id = student_id
        self.units_earned = 0
        # Any new instance variables would go here
        # self.student_age = <student-age-passed-in-as-parameter>

    def get_student_name(self):
        return self.student_name

    def get_student_id(self):
        return self.student_id

    def set_student_name(self, new_name):
        """
        This is the setter for the student name instance variable.
        Someone would use this method as follows:

            student2 = Student("Deepa", 09138740139)
            student2.set_student_name("Boshka")
            new_name = student2.get_student_name() --> new_name is "Boshka"
        """
        self.student_name = new_name

    def get_units_earned(self):
        return self.units_earned

    def set_units_earned(self, units):
        self.units_earned = units

    def increment_units(self, additional_units):
        """
        student3 = Student("Emily", 01937849823)
        student3.set_units(160)
        student3.increment_units(20)
        print(student3.get_units()) --> prints 180
        """
        self.units_earned += additional_units
        # return self.units_earned

    def can_graduate(self):
        # if self.units_earned >= UNITS_TO_GRADUATE:
        #     return True
        # else:
        #     return False
        #
        return self.units_earned >= UNITS_TO_GRADUATE
