"""
File: extract_city_data.py
--------------------------
This program reads in the us-cities.csv file and
parses it to write out a JSON file in the following
format:

{
    "city1" : [latitude1, longitude1],
    "city2" : [latitude2, longitude2],
    ...

}
"""

import json

INPUT_FILE = "us-cities.csv"

def main():
    data = {}
    with open("us-cities.csv", "r") as f:
        lines = f.readlines()
        cities = lines[1:]

        for city in cities:
            city = city.strip()
            elems = city.split(",")
            city_and_state = f"{elems[0]}, {elems[1]}"
            latitude = elems[2]
            longitude = elems[3]

            data[city_and_state] = [latitude, longitude]

    with open("us-cities.json", "w") as f2:
        json.dump(data, f2, indent=4)

if __name__ == "__main__":
    main()