"""
File: extract_city_data.py
--------------------------
This program reads in the us-cities.csv file and
parses it to write out a JSON file in the following
format:

{
    "city1,state" : [latitude1, longitude1],
    "city2,state" : [latitude2, longitude2],
    ...

}
"""

import json

INPUT_FILE = "us-cities.csv"
OUTPUT_FILE = "us-cities.json"

def main():

    data = {}
    with open(INPUT_FILE, "r") as f:

        lines = f.readlines()
        lines = lines[1:] # Chops out the first line, which is informative

        for line in lines:
            line = line.strip()
            elems = line.split(",")

            # If line is "Stanford,CA,37.422590,-122.165413"

            # city = Stanford
            city = elems[0]

            # state = CA
            state = elems[1]

            # latitude = 37.422590
            latitude = float(elems[2])

            # longitude = -122.165413
            longitude = float(elems[3])

            city_and_state = f"{city},{state}"
            data[city_and_state] = [latitude, longitude]

    with open(OUTPUT_FILE, "w") as f:
        json.dump(data, f, indent=4)

if __name__ == "__main__":
    main()