"""
File: phonebook.py
------------------
This file implements a fun phonebook program, 
where we can store people's phone numbers
and tell the user which numbers are available.
"""

import json

def lookup_numbers(phonebook):
    """
    Allow the user to lookup phone numbers in the phonebook
    by looking up the number associated with a name.
    """

    name = input("Enter name to lookup: ")
    if name not in phonebook:
        print(f"{name} is not in the phonebook")
    else:
        print(phonebook[name])

def print_phonebook(phonebook):
    """
    Prints out all the names/numbers in the phonebook.
    """
    for name in phonebook:
        print(name, "->", phonebook[name])

def add_new_number(phonebook):
    """
    Ask the user for a name/number to store in a phonebook (dictionary).
    """
    name = input("Name: ")
    number = input("Number: ")
    phonebook[name] = number


def main():
    phonebook = {}

    with open("phone_numbers.json", "r") as f:
        phonebook = json.load(f)

    while True:
        print("")  # adds an empty line
        print("What would you like to do?")
        print("(A)dd a new number")
        print("(L)ookup a number")
        print("(P)rint the phonebook")
        print("Press Enter to close")
        option = input("Enter a number: ")

        if option == "L":
            lookup_numbers(phonebook)
        if option == "A":
            add_new_number(phonebook)
        if option == "P":
            print_phonebook(phonebook)
        if option == "":
        	break

if __name__ == "__main__":
    main()