"""
File: remove_numbers.py
------------------------
This file implements the `remove_numbers` function
that accepts a string and returns a new string
with the characters from the original, but with
numbers removed.
"""


def remove_numbers(s):
	"""
	>>> remove_numbers("A123B")
	'AB'

	>>> remove_numbers("238481")
	''

	>>> remove_numbers("hello")
	'hello'

	>>> remove_numbers("a1b2c3")
	'abc'
	"""
	result = ""

	for ch in s:
		if not ch.isdigit():
			result += ch

	return result
