"""
File: GuessMyNumber.py
-----------------------
This program plays a game with the user, in which
the user will continue guessing the program's secret
number until they reach the right value. The program
tells the user if their guess is too low or too high.
"""

import random

SECRET_NUMBER_LOWER_BOUND = 1
SECRET_NUMBER_UPPER_BOUND = 99

def main():
    secret_number = random.randint(SECRET_NUMBER_LOWER_BOUND, SECRET_NUMBER_UPPER_BOUND)
    print(f"I am thinking of a number between {SECRET_NUMBER_LOWER_BOUND} and {SECRET_NUMBER_UPPER_BOUND}")

    # Read in user input as an int
    guess = int(input("Enter a guess: "))

    while guess != secret_number:
        if guess < secret_number:
            print("Your guess is too low!")
        else:
            print("Your guess is too high!")

        # Next guess
        print() # Blank line
        guess = int(input("Enter a guess: "))

    print(f"Congrats! You guessed the right number: {secret_number}")


if __name__ == "__main__":
    main()