from karel.stanfordkarel import *

"""
File: SteepleChaseKarel.py
--------------------------
Karel runs a steeple chase the is 10 avenues long.
Hurdles are of arbitrary height and placement.
"""

def turn_right():
    """
    Turns Karel 90 degrees clockwise, to the right.
    Precondition: None.
    Postcondition: Karel is 90 degrees clockwise from where they started.
    """
    for i in range(3):
        turn_left()

def descend_hurdle():
    """
    Karel will climb down from the top of a wall.
    Precondition: Karel is at the top of a wall, facing east.
    Postcondition: Karel is at the bottom of a wall, facing east.
    """
    turn_right() # Karel is facing south
    while front_is_clear():
        move()

    turn_left()

def ascend_hurdle():
    """
    Karel will climb a wall.
    Precondition: Karel is facing east and facing a wall.
    Postcondition: Karel is facing north, at the top of a wall.
    """
    turn_left() # Karel is now facing north
    while right_is_blocked():
        move()

def main():
    """
    To run a race that is 10 avenues long, we need to move
    forward or jump hurdles 9 times.
    """
    # Karel moves to the end of the world
    for i in range(9):
        if front_is_clear():
            move()
        else:
            # if front is blocked
            ascend_hurdle()
            turn_right()
            move()
            descend_hurdle()

# There is no need to edit code beyond this point

if __name__ == "__main__":
    run_karel_program()
