from karel.stanfordkarel import *

"""
File: RoombaKarel.py
---------------------
Karel will start at 1, 1 and clear all the beepers in the world
"""

def turn_right():
    """
    TODO: Leave a comment here
    """
    for i in range(3):
        turn_left()

def move_to_wall():
    """
    Karel moves to the end of the row or column.
    Precondition: None
    Postcondition: Karel is at the end of the row or column, facing a wall.
    """
    while front_is_clear():
        move()

def turn_around():
    """
    Turns Karel 180 degrees.
    Precondition: None.
    Postcondition: Karel is facing 180 degrees from the start position.
    """
    turn_left()
    turn_left()

def reset_to_next_row():
    """
    Karel moves back to the beginning of the row, and resets at the
    start of the next row.
    Precondition: Karel is at the end of a row (facing a wall).
    Postcondition: Karel is at the start of the row 1 above the start row.
    """
    turn_around()
    move_to_wall() # Karel is facing west
    turn_right()   # Karel is facing north
    move()
    turn_right()

def clear_beeper():
    """
    Karel picks up a beeper if there is one, no operation if not.
    Precondition: None
    Postcondition: Karel has picked up the beeper if there was one.
    """
    if beepers_present():
        pick_beeper()

def clear_row():
    """
    Karel moves to the end of the row, clearing all beepers along the way.
    Precondition: Karel is at the start of the row.
    Postcondition: Karel is at the end of the row, having picked up all beepers.
    """
    while front_is_clear():
        clear_beeper()
        move()

    clear_beeper() # OBOB: Need to clear last corner if there is a beeper

# The program starts by executing a special function called main
def main():
    while left_is_clear():
        clear_row()
        reset_to_next_row()

    clear_row() # OBOB: Make sure that Karel clears beepers in the last row

# This is "boilerplate" code which launches your Karel program
if __name__ == "__main__":
    run_karel_program()
