from karel.stanfordkarel import *

"""
File: MountainClimberKarel.py
-----------------------------
Karel will start at 1, 1 and climb the staircase of walls
in front. Once at the top, Karel will place a beeper, and
descend down to the last corner in the start row.
"""

def turn_right():
    """

    """
    for i in range(3):
        turn_left()

def step_down():
    """
    Karel descends to the next step on the mountain.
    Precondition: Karel is facing east not at a wall. Karel has a wall behind.
    Postcondition: Karel is at the next step, facing east, also not facing a wall.
    """
    move()
    turn_right()
    move()
    turn_left()


def descend_mountain():
    """
    Karel will descend the staircase structure and end up at
    the bottom of the mountain (end of the world).
    Precondition: Karel is at the top of the world, having placed a beeper.
    Postcondition: Karel is at the end of row 1, facing a wall.
    """
    while front_is_clear():
        step_down()

def step_up():
    """
    Karel climbs to the next step on the mountain.
    Precondition: Karel is facing east at a wall.
    Postcondition: Karel is at the next step, also facing a wall.
    """
    turn_left()
    move()
    turn_right()
    move()

def climb_mountain():
    """
    Karel starts by facing a wall, and climbs the staircase
    structure to make it to the top of the "mountain" of walls.
    Precondition: Karel starts at 1, 1 and is facing east, and facing a wall.
    Postcondition: Karel is at the top of the mountain, facing east
    """
    while front_is_blocked():
        step_up()

# The program starts by executing a special function called main
def main():
    climb_mountain()
    put_beeper()
    descend_mountain()

# This is "boilerplate" code which launches your Karel program
if __name__ == "__main__":
    run_karel_program()
