/* 
 * File:   main.cpp
 * Author: rsmehta
 *
 * Created on July 30, 2014, 12:56 PM
 */

#include <cstdlib>
#include "console.h"
#include "iostream"
#include "fstream"
#include "stdio.h"
#include "Rosenberg.h"
#include "time.h"
#include "error.h"
#include "string.h"
#include "simpio.h"
#include "tokenscanner.h"
using namespace std;

/*
 * 
 */
int main() {
      ofstream outfile;
      Map<node*, Map<string, long double> > calcs;
      Vector<int> initialS;
      Vector<int> initialC;
      Vector<double> times;
      string fromFile, initialStrS, initialStrC, numSpecies, tree, filename, monocond, timesstr;
      bool rmcheck;
      while(true){
          cout << "Read data from file? (y/N) (type q to quit): ";
          getline(cin, fromFile);
          if(fromFile == "y") {
              ifstream infile;
              infile.open("test.txt");
              if(infile.fail()) error("FAILURE");
              string nextline;
              getline(infile, nextline);
              int totalthings = stringToInteger(nextline);
              cout << "test4" << endl;
              int counter = 0;
              TokenScanner scanner;
              scanner.ignoreWhitespace();
              while(getline(infile, nextline)){
                  scanner.setInput(nextline);
                  numSpecies = scanner.nextToken();
                  tree = scanner.nextToken();
                  initialStrS = scanner.nextToken();
                  initialStrC = scanner.nextToken();
                  timesstr = scanner.nextToken();
                  monocond = scanner.nextToken();

                  if(monocond == "S"){
                      initialS = extractInitialSamples(initialStrS);
                      initialC = extractInitialSamples(initialStrC);
                      rmcheck = false;
                  }
                  else if(monocond == "C"){
                      initialS = extractInitialSamples(initialStrC);
                      initialC = extractInitialSamples(initialStrS);
                      rmcheck = false;
                  }
                  else if(monocond == "SC"){
                      initialS = extractInitialSamples(initialStrS);
                      initialC = extractInitialSamples(initialStrC);
                      rmcheck = true;
                  }
                  times = extractTimes(timesstr);
                  node* root = buildTree(tree);
                  int totalS = getTotalS(initialS);
                  int UB_s = 0, UB_c = 0;
                  for(int i = 0; i < initialS.size(); i++){
                      UB_s += initialS.get(i);
                  }
                  for(int i = 0; i < initialC.size(); i++){
                      UB_c += initialC.get(i);
                  }
                  loadInitialSamples(root, initialS);
                  loadInitialSamples(root, initialC);
                  getNodes(calcs, root);
                  markSubtree(root, totalS);
                  loadTimes(root, times);
                  inorder(root);
                  long double prob = calculateProb(root, 0, 0, 1, UB_s, UB_c, calcs, rmcheck, -1);
                  outfile << prob << endl;
                  cout << "Finished with " << counter << "/" << totalthings << " calculations." << endl;
                  counter++;
              }
          }
          else if (fromFile == "N"){
	    cout << "Not implemented at this time" << endl;
         }
         else if(fromFile == "q") return 0;
         else cout << "Incorrect input" << endl;
       }
      return 0;
}

