#ifndef MANUAL_INPUT_H
#define MANUAL_INPUT_H

#include <QWidget>
#include <QString>

namespace Ui {
class manual_input;
}

class manual_input : public QWidget
{
    Q_OBJECT

public:
    explicit manual_input(QWidget *parent = 0);
    ~manual_input();
    bool relayed;
    QString relayqstr;
    int calculation;

private slots:
    void on_numSpeciesBox_valueChanged(int arg1);

    void on_treebox_textChanged(const QString &arg1);

    void on_Sbox_textChanged(const QString &arg1);

    void on_Cbox_textChanged(const QString &arg1);

    void on_Tbox_textChanged(const QString &arg1);

    void on_chooseCalcBox_currentIndexChanged(int index);

    void on_handRunButton_clicked();

    void on_monocondbox_currentTextChanged(const QString &arg1);

    void on_handCancelButton_clicked();

private:
    Ui::manual_input *ui;
    int numSpecies; //Starts at 0 so that we know when the value (>=1) has been chosen
    std::string treestr, initialSstr, initialCstr, timesstr, monocondstr;
    bool treebool, initialSbool, initialCbool, timesbool, monocondbool;
};
#endif // MANUAL_INPUT_H
