#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "manual_input.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

private slots:
    void on_inputFileNameBox_textEdited(const QString &arg1);

    void on_outputFileNameBox_textEdited(const QString &arg1);

    void on_runButton_clicked();

    void on_calcChoiceBox_activated(int index);

    void on_manualInputButton_clicked();

    void getHandInputText();

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    QString inputfileqstring, outputfileqstring, handinputqstr;
    int calculation;
    manual_input *manual_input_window;
    bool manualstatus;
    bool manualwindowopened;
};

#endif // MAINWINDOW_H
