#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "iostream"
#include "fstream"
#include "stdio.h"
#include "Rosenberg.h"
//#include "time.h"
#include "error.h"
#include "strlib.h"
#include "string.h"
//#include "simpio.h"
#include "iomanip"
#include <time.h>
#include <algorithm>
#include "map.h"
#include "vector.h"
#include "tokenscanner.h"
#include <sstream>
#include "verify.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    calculation = 0;
    manualstatus = false;
    manualwindowopened = false;
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_inputFileNameBox_textEdited(const QString &arg1)
{
    inputfileqstring = arg1;
}

void MainWindow::on_outputFileNameBox_textEdited(const QString &arg1)
{
    outputfileqstring = arg1;
}

void MainWindow::on_runButton_clicked()
{
    // This function works for manual input or file input.
    stringstream errorsstr;
    ui->outputTextBox->clear();
    if(manualwindowopened == true){
        manualstatus = manual_input_window->relayed; // If the manual window has been opened, the program checks to see if it should run the manual code.
    }
    if(calculation > 0 || manualstatus == true){
        Map<node*, Map<string, long double> > calcs; // For memoization.
        Vector<int> initialS; // For initialization of species tree.
        Vector<int> initialC; // For initialization of species tree.
        Vector<double> times; // For initialization of species tree.
        int numS; // For construction of species tree.
        string tree, monocond; // Various storage strings.
        bool rmcheck; // True if RM, false if not.
        if(manualstatus == true){
            calculation = manual_input_window->calculation;
            handinputqstr = manual_input_window->relayqstr;
            TokenScanner scanner; // Used to read the calculation input.
            scanner.ignoreWhitespace(); // Whitespace is ignored; this reduces errors.
            scanner.scanStrings(); // We need to be able to scan strings.
            scanner.scanNumbers(); // We need to be able to scan numbers.
            //cout << handinputqstr.toStdString() << endl;
            scanner.setInput(handinputqstr.toStdString());
            numS = stringToInteger(scanner.nextToken());
            tree = scanner.nextToken(); // The next string should be the tree structure.
            tree = scanner.getStringValue(tree); // We saved the tree as a token; this converts it to a string.
            int UB_s = 0, UB_c = 0; // Upper bounds for summation indices for computational convenience.
            for(int i = 0; i < numS - 1; i++){ // The next string should be the S inputs, left-to-right.
                //cout << initialS.toString() << endl;
                initialS.add(stringToInteger(scanner.nextToken()));
                //cout << initialS.toString() << endl;
                scanner.verifyToken("/"); // There needs to be a slash between the S inputs.
            }
            initialS.add(stringToInteger(scanner.nextToken()));
            //cout << initialS.toString() << endl;
            if(calculation == 1){
                for(int i = 0; i < numS - 1; i++){ // The next string should be the C inputs, left-to-right.
                    //cout << initialC.toString() << endl;
                    initialC.add(stringToInteger(scanner.nextToken()));
                    //cout << initialC.toString() << endl;
                    scanner.verifyToken("/"); // There needs to be a slash between the C inputs.
                }
                initialC.add(stringToInteger(scanner.nextToken()));
                //cout << initialC.toString() << endl;
                reverse(initialC.begin(), initialC.end());
                for(int i = 0; i < initialC.size(); i++){
                    UB_c += initialC.get(i);
                }
            }
            //cout << "now doing times" << endl;
            for(int i = 0; i < 2 * numS - 2; i++){ // The next string should be the branch lengths, in-order left-to-right.
                //cout << times.toString() << endl;
                string nextoken = scanner.nextToken();
                //cout << nextoken << endl;
                times.add(stringToReal(nextoken));
                //cout << times.toString() << endl;
                scanner.verifyToken("/"); // The branch lengths need to be separated by a slash.
            }
            times.add(stringToReal(scanner.nextToken()));
            //cout << times.toString() << endl;
            reverse(initialS.begin(), initialS.end()); // The S and C inputs and branch lengths were read in backwards (don't worry about it).
            reverse(times.begin(), times.end());
            int totalS; // Stores the total number of initial S lineages (needed for calculation efficiency)
            totalS = getTotalS(initialS);  // Gets total number of initial S lineages.
            for(int i = 0; i < initialS.size(); i++){
                UB_s += initialS.get(i);
            }
            if(calculation == 1){
                monocond = scanner.nextToken(); // The next string should be the (positively-defined) monophyly condition (S, C, or SC).
                Vector<int> holder; // If the monophyly condition is C, we need to relabel the tree (T_{SC} --> T_{CS})
                if(monocond == "S"){
                    rmcheck = false;
                }
                else if(monocond == "C"){
                    holder = initialS;
                    initialS = initialC;
                    initialC = holder;
                    rmcheck = false;
                }
                else if(monocond == "SC"){
                    rmcheck = true;
                }
            }
            node* root;
            long double prob;
            float tfloat;
            if(calculation == 1){
                root = buildTree(tree); // Builds the species tree in a data structure.
                loadInitialSamples(root, initialS); // Initializes the tree structure with S lineages.
                loadInitialSamples(root, initialC); // Initializes the tree structure with C lineages.
                getNodes(calcs, root); // Used for memoization.
                markSubtree(root, totalS); // Marks the minimal S subtree for RM.
                loadTimes(root, times); // Initializes the tree structure with branch lengths.
                clock_t t = clock(); // Timing recording
                prob = calculateProb(root, 0, 0, 1, UB_s, UB_c, calcs, rmcheck, -1); // The actual calculation.
                t = clock() - t; // Timing recording
                tfloat = (float)t;
            }
            else if(calculation == 2){
                clock_t t = clock();
                prob = r2003resultRM(initialS.get(0), initialS.get(1), times.get(0), times.get(2)); // Not a typo; times[1] = 5001
                t = clock() - t;
                tfloat = (float)t;
            }
            else if(calculation == 3){
                clock_t t = clock();
                prob = myresult(initialS.get(0), initialS.get(1), initialS.get(2), times.get(2), times.get(0), times.get(1), times.get(4)); // Again, looks wrong but should be correct
                t = clock() - t;
                tfloat = (float)t;
            }
            else if(calculation == 4){
                clock_t t = clock();
                prob = myresult4(initialS.get(0), initialS.get(1), initialS.get(2), initialS.get(3), times.get(6), times.get(4), times.get(2), times.get(0), times.get(1), times.get(5), true); // Again, looks wrong but should be correct
                t = clock() - t;
                tfloat = (float)t;
            }
            else if(calculation == 5){
                clock_t t = clock();
                prob = myresult4(initialS.get(0), initialS.get(1), initialS.get(2), initialS.get(3), times.get(6), times.get(4), times.get(2), times.get(0), times.get(1), times.get(3), false); // Again, looks wrong but should be correct
                t = clock() - t;
                tfloat = (float)t;
            }
            else{
                error("Undefined calculation");
            }
            stringstream toBox;
            QString toBoxq;
            toBox << "Finished with manual input calculation." << endl;
            toBox << " " << tfloat/CLOCKS_PER_SEC << " seconds " << endl;
            toBox << "Probability is: " << prob << endl;
            toBoxq  = QString::fromStdString(toBox.str());
            ui->outputTextBox->appendPlainText(toBoxq);
        }
        else{
            // For file input, not manual input
            string infilename = inputfileqstring.toStdString();
            string outfilename = outputfileqstring.toStdString();
            ofstream outfile; // Output file stream.
            srand(time(NULL)); // Timing calculations for log file.
            // We now open our file streams.
            outfile.open(outfilename.c_str());
            ifstream infile;
            infile.open(infilename.c_str());
            if(infile.fail()){
                ui->outputTextBox->setPlainText("Failure to open file.  Check to see if your filename is correct and if the file is in the correct folder.");
            }
            else{
                string nextline;
                getline(infile, nextline); // The first line in the file is a standardized starting string: "file start"
                //cout << nextline << endl;
                if(nextline != "file start"){
                    errorsstr.str(std::string());
                    errorsstr << "Error line 1: expected <file start>, instead got <" << nextline << ">." ;
                    ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                }
                else{
                    getline(infile, nextline);
                    //cout << nextline << endl;
                    if(!stringIsInteger(nextline)){
                        errorsstr.str(std::string());
                        errorsstr << "Error line 2: expected number of species, instead got <" << nextline << ">.";
                        ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                    }
                    else{
                        int totalthings = stringToInteger(nextline); // The next line will indicate the number of calculations, for the log file.
                        ui->progressBar->setMinimum(0);
                        ui->progressBar->setMaximum(totalthings);
                        int counter = 0; // Counts the number of calculations completed; used for log file.
                        TokenScanner scanner; // Used to read the calculation input.
                        scanner.ignoreWhitespace(); // Whitespace is ignored; this reduces errors.
                        scanner.scanStrings(); // We need to be able to scan strings.
                        scanner.scanNumbers(); // We need to be able to scan numbers.
                        // The following loop reads through the remainder of the file (which should contain all the desired calculations)
                        bool failed = false;
                        while(getline(infile, nextline)){
                            if(failed){
                                break;
                            }
                            //cout << nextline << endl;
                            scanner.setInput(nextline); // Prepare to scan the line
                            string nextoken = scanner.nextToken();
                            //cout << nextoken << endl;
                            if(!stringIsInteger(nextoken)){
                                errorsstr.str(std::string());
                                errorsstr << "Error line " << counter + 3 << ": number of species <" << nextoken << "> not an integer";
                                ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                                failed = true;
                            }
                            else{
                                numS = stringToInteger(nextoken); // The first string should be the number of species, numS
                                tree = scanner.nextToken(); // The next string should be the tree structure.
                                ////cout << tree << endl;
                                //Here is where we verify the tree in approximately the same way we did for the manual input
                                if(verifyTree(tree, ui, counter, numS)){
                                    tree = scanner.getStringValue(tree); // We saved the tree as a token; this converts it to a string.
                                    //And now we move on beyond the tree.  Note that I will leave out some "else" statements for brevity.
                                    //cout << "Looking at inputs now" << endl;
                                    if(verifySamples(scanner, ui, counter, numS, initialS)){
                                        reverse(initialS.begin(), initialS.end()); // The S and C inputs and branch lengths were read in backwards (don't worry about it).
                                        long double prob;
                                        float tfloat;
                                        if(calculation > 1 || (calculation  == 1 && verifySamples(scanner, ui, counter, numS, initialC))){ // We only do the C lineages if the calculation is single-subset (1)
                                            reverse(initialC.begin(), initialC.end());
                                            if(verifyTimes(scanner, ui, counter, numS, times)){
                                                reverse(times.begin(), times.end());
                                                if(calculation == 1){ //Now we finish the single-subset calculation (1)
                                                    bool checksout = true;
                                                    for(size_t i = 0; i < initialS.size(); ++i){
                                                        if(initialS.get(i) + initialC.get(i) == 0){
                                                            checksout = false;
                                                            errorsstr.str(std::string());
                                                            errorsstr << "Error line " << counter + 3 << ": species has no input lineages S:<" << initialS.toString() << "> C:<" << initialC.toString() << ">";
                                                            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                                                            failed = true;
                                                        }
                                                    }
                                                    if(checksout){
                                                        monocond = scanner.nextToken(); // The next string should be the (positively-defined) monophyly condition (S, C, or SC).
                                                        ////cout << monocond << endl;
                                                        if(verifyMonocond(monocond, initialS, initialC, counter, rmcheck, ui)){
                                                            outfile << tree << " " << initialS << " " << initialC << " " << times << " " << monocond << " "; // Prints the inputs to the output file.
                                                            int totalS; // Stores the total number of initial S lineages (needed for calculation efficiency)
                                                            totalS = getTotalS(initialS);  // Gets total number of initial S lineages.
                                                            node* root = buildTree(tree); // Builds the species tree in a data structure.
                                                            int UB_s = 0, UB_c = 0; // Upper bounds for summation indices for computational convenience.
                                                            for(int i = 0; i < initialS.size(); i++){
                                                                UB_s += initialS.get(i);
                                                            }
                                                            for(int i = 0; i < initialC.size(); i++){
                                                                UB_c += initialC.get(i);
                                                            }
                                                            loadInitialSamples(root, initialS); // Initializes the tree structure with S lineages.
                                                            loadInitialSamples(root, initialC); // Initializes the tree structure with C lineages.
                                                            getNodes(calcs, root); // Used for memoization.
                                                            markSubtree(root, totalS); // Marks the minimal S subtree for RM.
                                                            loadTimes(root, times); // Initializes the tree structure with branch lengths.
                                                            clock_t t = clock(); // Timing recording for log file.
                                                            prob = calculateProb(root, 0, 0, 1, UB_s, UB_c, calcs, rmcheck, -1); // The actual calculation.
                                                            t = clock() - t; // Timing recording for log file.
                                                            counter++; // Counting calculations for log file.
                                                            outfile << prob << endl; // Result printed in output file.
                                                            stringstream toBox;
                                                            QString toBoxq;
                                                            toBox << "Finished with " << counter << "/" << totalthings << " calculations." << endl;
                                                            toBox << " " << ((float)t)/CLOCKS_PER_SEC << " seconds " << endl;
                                                            toBoxq  = QString::fromStdString(toBox.str());
                                                            ui->outputTextBox->appendPlainText(toBoxq);
                                                            ui->progressBar->setValue(counter);
                                                        }}
                                                }
                                                else if(calculation == 2){
                                                    bool checksout = true;
                                                    for(size_t i = 0; i < initialS.size(); ++i){
                                                        if(initialS.get(i) == 0){
                                                            checksout = false;
                                                            errorsstr.str(std::string());
                                                            errorsstr << "Error line " << counter + 3 << ": species in <" << initialS.toString() << "> has no input lineages.";
                                                            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                                                            failed = true;
                                                        }
                                                    }
                                                    if(checksout){
                                                        clock_t t = clock();
                                                        prob = r2003resultRM(initialS.get(0), initialS.get(1), times.get(0), times.get(2)); // Not a typo; times[1] = 5001
                                                        t = clock() - t;
                                                        tfloat = (float)t;
                                                        outfile << tree << " " << initialS << " " << times << " " << prob << endl;
                                                        counter++;
                                                        stringstream toBox;
                                                        QString toBoxq;
                                                        toBox << "Finished with " << counter << "/" << totalthings << " calculations." << endl;
                                                        toBox << " " << ((float)t)/CLOCKS_PER_SEC << " seconds " << endl;
                                                        toBoxq  = QString::fromStdString(toBox.str());
                                                        ui->outputTextBox->appendPlainText(toBoxq);
                                                        ui->progressBar->setValue(counter);
                                                    }
                                                }
                                                else if(calculation == 3){
                                                    bool checksout = true;
                                                    for(size_t i = 0; i < initialS.size(); ++i){
                                                        if(initialS.get(i) == 0){
                                                            checksout = false;
                                                            errorsstr.str(std::string());
                                                            errorsstr << "Error line " << counter + 3 << ": species in <" << initialS.toString() << "> has no input lineages.";
                                                            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                                                            failed = true;
                                                        }
                                                    }
                                                    if(checksout){
                                                        clock_t t = clock();
                                                        prob = myresult(initialS.get(0), initialS.get(1), initialS.get(2), times.get(2), times.get(0), times.get(1), times.get(4)); // Again, looks wrong but should be correct
                                                        t = clock() - t;
                                                        tfloat = (float)t;
                                                        outfile << tree << " " << initialS << " " << times << " " << prob << endl;
                                                        counter++;
                                                        stringstream toBox;
                                                        QString toBoxq;
                                                        toBox << "Finished with " << counter << "/" << totalthings << " calculations." << endl;
                                                        toBox << " " << ((float)t)/CLOCKS_PER_SEC << " seconds " << endl;
                                                        toBoxq  = QString::fromStdString(toBox.str());
                                                        ui->outputTextBox->appendPlainText(toBoxq);
                                                        ui->progressBar->setValue(counter);
                                                    }
                                                }
                                                else if(calculation == 4){
                                                    bool checksout = true;
                                                    for(size_t i = 0; i < initialS.size(); ++i){
                                                        if(initialS.get(i) == 0){
                                                            checksout = false;
                                                            errorsstr.str(std::string());
                                                            errorsstr << "Error line " << counter + 3 << ": species in <" << initialS.toString() << "> has no input lineages.";
                                                            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                                                            failed = true;
                                                        }
                                                    }
                                                    if(checksout){
                                                        clock_t t = clock();
                                                        prob = myresult4(initialS.get(0), initialS.get(1), initialS.get(2), initialS.get(3), times.get(6), times.get(4), times.get(2), times.get(0), times.get(1), times.get(5), true); // Again, looks wrong but should be correct
                                                        t = clock() - t;
                                                        tfloat = (float)t;
                                                        outfile << tree << " " << initialS << " " << times << " " << prob << endl;
                                                        counter++;
                                                        stringstream toBox;
                                                        QString toBoxq;
                                                        toBox << "Finished with " << counter << "/" << totalthings << " calculations." << endl;
                                                        toBox << " " << ((float)t)/CLOCKS_PER_SEC << " seconds " << endl;
                                                        toBoxq  = QString::fromStdString(toBox.str());
                                                        ui->outputTextBox->appendPlainText(toBoxq);
                                                        ui->progressBar->setValue(counter);
                                                    }
                                                }
                                                else if(calculation == 5){
                                                    bool checksout = true;
                                                    for(size_t i = 0; i < initialS.size(); ++i){
                                                        if(initialS.get(i) == 0){
                                                            checksout = false;
                                                            errorsstr.str(std::string());
                                                            errorsstr << "Error line " << counter + 3 << ": species in <" << initialS.toString() << "> has no input lineages.";
                                                            ui->outputTextBox->setPlainText(QString::fromStdString(errorsstr.str()));
                                                            failed = true;
                                                        }
                                                    }
                                                    if(checksout){
                                                        clock_t t = clock();
                                                        prob = myresult4(initialS.get(0), initialS.get(1), initialS.get(2), initialS.get(3), times.get(6), times.get(4), times.get(2), times.get(0), times.get(1), times.get(3), false); // Again, looks wrong but should be correct
                                                        t = clock() - t;
                                                        tfloat = (float)t;
                                                        outfile << tree << " " << initialS << " " << times << " " << prob << endl;
                                                        counter++;
                                                        stringstream toBox;
                                                        QString toBoxq;
                                                        toBox << "Finished with " << counter << "/" << totalthings << " calculations." << endl;
                                                        toBox << " " << ((float)t)/CLOCKS_PER_SEC << " seconds " << endl;
                                                        toBoxq  = QString::fromStdString(toBox.str());
                                                        ui->outputTextBox->appendPlainText(toBoxq);
                                                        ui->progressBar->setValue(counter);
                                                    }
                                                }
                                                else{
                                                    error("Undefined calculation");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            infile.close(); // Closes input file.
            outfile.close(); // Closes output file.
            return;
        }
    }
    else{
        ui->outputTextBox->clear();
        QString iAmDisappoint;
        string iAmDisappointstr = "Please choose a calculation.";
        iAmDisappoint = QString::fromStdString(iAmDisappointstr);
        ui->outputTextBox->appendPlainText(iAmDisappoint);
    }
}

void MainWindow::on_calcChoiceBox_activated(int index)
{
    calculation = index;
}

void MainWindow::on_manualInputButton_clicked()
{
    manual_input_window = new manual_input(); // Note I have to deconstruct this window at some point.
    manual_input_window->setAttribute(Qt::WA_DeleteOnClose);
    manual_input_window->show();
    manualwindowopened = true;
}

void MainWindow::getHandInputText()
{
    handinputqstr = manual_input_window->relayqstr;
}
