#ifndef ROSENBERG_H
#define ROSENBERG_H

#include "tree.h"

long double fSmallFunction(int k, int a, int b){
   long double value = 0;
    for(int x = max(1, k + 1 - b ); x <= a; x++){
        for(int y = max(1, k + 1 - x); y <= b; y++){
                long double term, term1n, term1d, term1, term2n, term2d, term2, term3n, term3d, term3, term4n, term4d, term4;
                term1n = (fact(a)/(fact(x)*fact(a - x)))*(fact(b)/(fact(y)*fact(b - y)));
                term1d = (fact(a + b)/(fact(x + y)*fact(a + b - x - y)));
                term2n = (fact(x + y )/(fact(x)*fact(y)));
                term2d = (fact(a + b)/(fact(a)*fact(b)));
                term3n = a + b;
                term3d = a * b;
                term4n = 2 * (x * y)*(x * y);
                term4d = (x  + y)*(x + y) * (x + y - 1);
                term1 = term1n / term1d;
                term2 = term2n / term2d;
                term3 = term3n / term3d;
                term4 = term4n / term4d;
                term = term1 * term2 * term3 * term4;
                value += term;
        }
    }
    return value;
}

long double fFunction(int k, int a, int b, int c){
   long double value = 0;
    for(int x = max(1, k + 1 - b - c); x <= a; x++){
        for(int y = max(1, k + 1 - x - c); y <= b; y++){
            for(int z = max(1, k + 1 - x - y); z <= c; z++){
                long double term, term1n, term1d, term1, term2n, term2d, term2, term3n, term3d, term3, term4n, term4d, term4;
                term1n = (fact(a)/(fact(x)*fact(a - x)))*(fact(b)/(fact(y)*fact(b - y)))*(fact(c)/(fact(z)*fact(c - z)));
                term1d = (fact(a + b + c)/(fact(x + y + z)*fact(a + b + c - x - y - z)));
                term2n = (fact(x + y + z)/(fact(x)*fact(y)*fact(z)));
                term2d = (fact(a + b + c)/(fact(a)*fact(b)*fact(c)));
                term3n = a + b + c;
                term3d = a * b * c;
                term4n = 2 * (x * y)*(x * y) * z;
                term4d = (x  + y + z)*(x + y + z) * (x + y + z - 1);
                term1 = term1n / term1d;
                term2 = term2n / term2d;
                term3 = term3n / term3d;
                term4 = term4n / term4d;
                term = term1 * term2 * term3 * term4;
                value += term;
            }
        }
    }
    return value;
}

long double r2003result(int r_A, int r_B, double T_A, double T_B){
    long double value = 0;
    for(int q_A = 0; q_A <= r_A; q_A++){
        for(int q_B = 0; q_B <= r_B; q_B++){
            if(q_A + q_B > 0){
                long double prod1, prod2, summand = 0;
                prod1 = gFunction(r_A, q_A, T_A) * gFunction(r_B, q_B, T_B);
                for(int k = 1; k <= q_B; k++){
                    summand += iFunction(q_A, 1) * iFunction(q_B, k) * wSub2(q_A - 1, q_B - k) * k * iFunction(k, 1);
                }
                if(iFunction(q_A + q_B, 1) > 10000 || iFunction(q_A + q_B, 1) < 0) prod2 = 0;
                else {prod2 = prod1 * summand / iFunction(q_A + q_B, 1);}
                value += prod2;
            }
        }
    }
    return value;
}

long double r2003resultRM(int r_A, int r_B, double T_A, double T_B){
    long double value = 0;
    for(int q_A = 0; q_A <= r_A; q_A++){
        for(int q_B = 0; q_B <= r_B; q_B++){
            if(q_A + q_B > 1){
                long double prod1, prod2;
                long long int choose;
                prod1 = gFunction(r_A, q_A, T_A) * gFunction(r_B, q_B, T_B);
                choose = fact(q_A + q_B)/(fact(q_A) * fact(q_B)) * (q_A + q_B - 1);
                prod2 = prod1 * 2 / choose;
                value += prod2;
            }
        }
    }
    return value;
}

long double r2002result(int r, int s, int q, double T_3, double T_2){
    long double value = 0;
    for(int m = 1; m <= r; m++){
        for(int n = 1; n <= s; n++){
            for(int k = 1; k <= m + n; k++){
                for(int l = 1; l <= q; l++){
                        long double term1, term2, summand = 0;
                        term1 = gFunction(r, m, T_3) * gFunction(s, n, T_3) * gFunction(m + n, k, T_2) * gFunction(q, l, T_2 + T_3);

                        if(k == 1){
                            term2 = (1 - fSmallFunction(2, m, n)) * 2 / (l * (l + 1));
                        }
                        else {
                            for(int x = 1; x <= k - 1; x++){
                                summand += (1 - fFunction(3, x, k - x, l) - fFunction(3, x, l, k - x) - fFunction(3, k - x, l, x)) * wFunction(m, n, x, k, T_2);
                            }
                            term2 = (1 - fSmallFunction(k, m, n)) * summand;
                        }
                        value += term1 * term2;
                    }
                }
        }
    }
    return value;
}

long double myresult(int r, int s, int q, double T_3, double T_2){
    long double value = 0;
    for(int m = 0; m <= r; m++){
        for(int n = 0; n <= s; n++){
        for(int x = 0; x <= m; x++){
        for(int k = x; k <= n + x; k++){
            for(int l = 0; l <= q; l++){
                for(int m_I = 0; m_I <= 1; m_I++){

                                long double term1, term2, term3;
                                term1 = gFunction(r, m, T_3) * gFunction(s, n, T_3) * gFunction(m + n, k, T_2) * gFunction(q, l, T_2 + T_3);

                                if(k == 1 && x == 0){
                                    term2 = iFunction(m, 1) * iFunction(n, 1) * wSub2(m - 1, n - 1) / iFunction(m + n, 1);
                                }
                                else{
                                    term2 = iFunction(m, x) * iFunction(n, k - x) * wSub2(m - x, n - k + x) / iFunction(m + n, k);
                                }
                                if(m_I == 0){
                                    term3 = 3 * iFunction(x, 1) * iFunction(k - x, 1) * iFunction(l, 1) * wSub3(x - 1, k - x - 1, l - 1) / iFunction(k + l, 1);
                                }
                                else{
                                    term3 = 2 / (l * (l + 1));
                                }
                                value += term1 * term2 * term3; //Not really.
                            }
                        }
                }
            }
        }
    }
    return value;
}




#endif // ROSENBERG_H
