************************************************************************
*
*     File  mi00main fortran
*
*     MIMAIN  (main program)
*     minos1   minos2   minos3
*
* 12 Jul 2000: Stand-alone MINOS routines gathered here.
* 14 Aug 2000: mistart now required.
* 01 Oct 2002: LU Rook Pivoting now recognized.
* 02 Feb 2004: (At GAMS) minose implemented.
* 14 Feb 2004: misolf implemented.
* 10 Mar 2004: m5lpit and m7rgit prevent new nonbasics from being
*              slightly inside their bound.  This fixes strange bug
*              in "Max Dual infeas" following EXIT msg.
* 31 Jul 2004: m5solv ensures Phase 1 works hard enough with ns > 0
*              independent of loose Optimality tol.
* 08 Sep 2014: Changed 'double precision'
*              to      'real(8)         ' everywhere
*              to facilitate changing
*                      'real(8) '
*              to      'real(16)'
* 04 Nov 2014: m2xsol implemented in mi40bfil.f to export solution
*              to fort.81 for use by the Cobra toolbox.
*              Activated by runtime option   Report file 81
* 02 May 2015: (m3dflt) Hessian dimension limited to 32768 to avoid overflow.
*
************************************************************************
*                                                                      *
*                            M I N O S                                 *
*                                                                      *
*          A Modular In-core Nonlinear Optimization System             *
*                                                                      *
*               Version 5.6            02 May 2015                     *
*                                                                      *
*          Bruce A. Murtagh            Michael A. Saunders             *
*                                                                      *
*                                                                      *
*          Copyright 1980 - 2015       Stanford University             *
*                                                                      *
************************************************************************
*
*  MINOS Fortran source files:
*
*  mi00main   Main program for stand-alone MINOS
*             reading multiple SPECS and MPS files
*  mi02lib    MINOS subroutine library routines
*             (minos, minoss, mispec)
*  mi05funs   User routines
*  mi10pc   }
*  mi10unix } Machine-dependent routines
*  mi10vms  }
*  mi11sys    System routines that are the same for Unix, Linux, PC etc
*  mi12solv   misolv: Called from minos3 and minoss
*  mi15blas   Basic Linear Algebra Subprograms.  A subset of BLAS Level 1.
*  mi17util   Additional utilities
*  mi20amat   Core allocation and manipulation of ( A  I )
*  mi21amat   m2apr1, m2apr5: Called from m2aprd in mi20amat
*  mi25bfac   m2bfac: Drives basis factorization routines
*  mi26bfac   Basis factorization routines
*  mi27lu     LUSOL routines for MINOS (Factor, Solve and Replace-Column)
*  mi30spec   SPECS file routines
*  mi35mps    m3inpt: Drives MPS file input routines
*  mi36mps    MPS file input routines
*  mi40bfil   Basis file and solution output routines
*  mi50lp     Routines for the primal simplex method
*  mi60srch   Routines for the linesearch and subproblem obj
*  mi65rmod   Maintains R, the approximate reduced Hessian
*  mi70nobj   Nonlinear objective routines implementing
*             the reduced-gradient algorithm
*  mi80ncon   Nonlinear constraint routines implementing
*             the projected augmented Lagrangian algorithm
*             (a form of Robinson's SLC algorithm)
*  mi81ncon   m8aug1: Called from m8augl in mi80ncon
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      program            MIMAIN
      implicit           real(16)         (a-h,o-z)

*     ------------------------------------------------------------------
*     This is the default main program for MINOS.
*     It provides all of the necessary workspace.
*     If your compiler wants all common blocks to be in the main program
*     (e.g. MACFORTRAN), grab them from subroutine misolv in file mi10..
*     ------------------------------------------------------------------

      parameter           (nwcore = 5000000)
      real(16)           z(nwcore)

      call minos1( z, nwcore )

      end ! main program for stand-alone MINOS

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine minos1( z, nwcore )

      implicit           real(16)         (a-h,o-z)
      real(16)           z(nwcore)

*     ------------------------------------------------------------------
*     minos1 is used for the stand-alone version of MINOS.
*     It is called by the main program (or equivalent driver).
*     It repeatedly looks for a new problem in the SPECS file
*     and asks for it to be solved, until m3file returns inform gt 1,
*     which means an ENDRUN card was found in the SPECS file,
*     or end-of-file was encountered.
*
*     06 Oct 1985: minos1 calls minos2 to allow reallocation of z(*),
*                  following suggestions from David Gay,
*                  AT&T Bell Laboratories (for Unix).
*     22 Dec 1987: For DEC VAX VMS, newz tells minos2 whether or not to
*                  re-allocate z(*).
*     03 Mar 1988: f77 version calls m3file.
*     01 Oct 1991: mispec and misolv implemented.
*     02 Apr 1993: Have to initialize ltime before calling m1time.
*     13 Aug 1993: opfile renamed m3file.
*     05 Feb 1998: Estimate njac here rather than in m2core.
*     ------------------------------------------------------------------

      common    /m1file/ iread,iprint,isumm
      common    /m1savz/ nbytes,newz
      parameter        ( ntime = 5 )
      common    /m1tim / tlast(ntime), tsum(ntime), numt(ntime), ltime
      common    /m2file/ iback,idump,iload,imps,inewb,insrt,
     $                   ioldb,ipnch,iprob,iscr,isoln,ispecs,ireprt
      common    /m2mapz/ maxw  ,maxz
      common    /m8len / njac  ,nncon ,nncon0,nnjac

      external           m3key

      newz   = 0

*     ------------------------------------------------------------------
*     Define global files (reader, printer, etc.)
*     ------------------------------------------------------------------
      iprint = 9
      isumm  = 6
      ispecs = 4
      call mistart( iprint, isumm, ispecs )

*     ==================================================================
*     Loop through each problem in the SPECS file.
*     ==================================================================
      do 100 loop = 1, 100000
         ncalls = loop
         maxw   = 0
         maxz   = nwcore

*        Initialize timers.

         ltime  = 1
         call m1time( 0,0 )

*        ---------------------------------------------------------------
*        Define the MINOS title and read the Specs file.
*        ---------------------------------------------------------------
         call m3file( ncalls, ispecs, m3key,
     $                iprint, isumm, inform )

         if (inform .ge. 2) then
            inform = 100 + inform
            return
         end if

*        ---------------------------------------------------------------
*        Check options.
*        Open files needed for this problem.
*        ---------------------------------------------------------------
         call m3dflt( 2 )
         call mifile( 2 )

*        ---------------------------------------------------------------
*        Estimate storage requirements using the
*        following Common variables:
*           (m2len )   mrows, mcols, melms
*           (m3len )   nscl
*           (m5len )   maxr, maxs
*           (m7len )   nnobj
*           (m8len )   njac, nncon, nnjac
*        All except njac have been set by default or by the SPECS file.
*        We haven't read the MPS file yet, so estimate njac here.
*        ---------------------------------------------------------------
         njac  = min( 10, nncon) * nnjac
         call m2core( 1, mincor )

*        ---------------------------------------------------------------
*        Solve the problem.
*        ---------------------------------------------------------------
         call minos2( z, nwcore, mincor, inform )
  100 continue
*     ==================================================================
*     End of loop through SPECS file.
*     ==================================================================

*     end of minos1
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine minos2( z, nwcore, mincor, inform )

      implicit           real(16)         (a-h,o-z)
      real(16)           z(nwcore)

*     ------------------------------------------------------------------
*     minos2 asks minos3 to solve the problem just found in the SPECS
*     file.  For standard Fortran installations, that is all.
*
*     For some installations, this is an appropriate place to
*     increase the size of the workspace array  z,  to allow
*     solution of arbitrarily large problems without recompiling
*     the main program, in which z(nwcore) is originally declared.
*
*     z  might have to be in blank common if it is to be expanded.
*     The default size  nwcore  should be large enough to solve
*     reasonably big problems without change (e.g., nwcore = 100000).
*
*     At this stage, the SPECS file has been read and values are known
*     for maxw, maxz and mincor.  The default values for the first two
*     are maxw = 0 and maxz = nwcore, but we allow the user to alter
*     these by means of two cards in the SPECS file of the following
*     form...
*
*        Workspace (user)      10000 words  (This sets  maxw = 10000)
*        Workspace (total)     90000 words  (This sets  maxz = 90000)
*
*     MINOS will use only  Z(maxw+1), ..., Z(maxz).  Hence,
*     z(1), ..., z(maxw)    and possibly   z(maxz+1), ..., z(nwcore)
*     may be used as workspace by the user during solution of this
*     particular problem (e.g., within funobj or funcon).
*
*     If maxz is set to a value less than nwcore, it may serve to
*     reduce paging activity on a machine with virtual memory, by
*     confining MINOS (in particular the basis-factorization routines)
*     to an area of core that is sensible for the current problem.
*     On some systems (e.g., Burroughs), this will allow z(nwcore)
*     to be declared arbitrarily large at compile time.
*
*     mincor contains an estimate of the minimum core requirements,
*     allowing for maxw but ignoring maxz.  z is already large enough
*     if nwcore .ge. max( maxz, mincor ).  Systems that allow z to be
*     re-allocated at run-time should make appropriate use of the
*     logical variable enough.
*
*     22 Dec 1987: VAX dynamic storage added by Steve White, DSIR, NZ.
*     ------------------------------------------------------------------

      common    /m1file/ iread,iprint,isumm
      common    /m1savz/ nbytes,newz
      common    /m2mapz/ maxw  ,maxz

      logical            enough

      if (iprint .gt. 0) write(iprint, 1100) maxw, mincor
      nwcor2 = max( maxz, mincor )

*     ------------------------------------------------------------------
*-->  Machine dependency.
*     enough = .true.                for most systems.
*     enough = nwcore .ge. nwcor2    if we are prepared to change the
*                                    length of z(*), e.g. DEC OpenVMS.
*     ------------------------------------------------------------------
      enough = nwcore .ge. nwcor2
      enough = .true.

      if ( enough ) then

*        Use the storage already available.

         maxz   = min( maxz, nwcore )
         if (iprint .gt. 0) write(iprint, 1200) maxw, maxz, nwcore
         call minos3( z, nwcore, inform )
      else

*        Re-allocate  z  (using some non-standard Fortran).
*        newz says if we have to free z from an earlier call.
*-->     The following is for DEC OpenVMS.

*        nwcor2 = max( nwcore, maxz, mincor )
*        if (newz .ne. 0) then
*           istat = lib$free_vm( nbytes, newz )
*           if (.not. istat) then
*              call lib$signal( %val(istat) )
*           end if
*        end if
*        maxz   = nwcor2
*        nbytes = nwcor2*8
*        istat  = lib$get_vm( nbytes, newz )
*        if (.not. istat) then
*           call lib$signal( %val(istat) )
*        else
*           if (iprint .gt. 0) write(iprint, 1200) maxw, maxz, nwcor2
*           call minos3( %val(newz), nwcor2, inform )
*        end if
      end if
      return

 1100 format(/ ' Reasonable Workspace limits are', i10, ' ...', i8)
 1200 format(  ' Actual     Workspace limits are', i10, ' ...',
     $   i8, ' ...', i8, '  words of  z.')

*     end of minos2
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine minos3( z, nwcore, inform )

      implicit           real(16)         (a-h,o-z)
      real(16)           z(nwcore)

*     ------------------------------------------------------------------
*     minos3 prints the options (sometimes),
*     then reads a problem from an MPS file
*     and asks misolv to solve it.
*
*     01 Oct 1991: misolv implemented.
*     20 Apr 1992: name1, name2, nname added as parameters to misolv.
*     26 Apr 1992: call m3dflt( 3 ) added.
*     ------------------------------------------------------------------

      common    /m2mapa/ ne    ,nka   ,la    ,lha   ,lka
      common    /m3len / m     ,n     ,nb    ,nscl
      common    /m3loc / lascal,lbl   ,lbu   ,lbbl  ,lbbu  ,
     $                   lhrtyp,lhs   ,lkb
      common    /m3mps1/ lname1,lname2,lkeynm,nname
      common    /m5loc / lpi   ,lpi2  ,lw    ,lw2   ,
     $                   lx    ,lx2   ,ly    ,ly2   ,
     $                   lgsub ,lgsub2,lgrd  ,lgrd2 ,
     $                   lr    ,lrg   ,lrg2  ,lxn
      common    /m5lobj/ sinf,wtobj,minimz,ninf,iobj,jobj,kobj
      common    /m5log1/ idebug,ierr  ,lprint

      external           micore     ! Any external for misolv to ignore.
*     ------------------------------------------------------------------

      ifuser = 0  ! So misolv won't call dummy external "micore".

      call m3dflt( 3 )
      call m1time( 1,0 )
      call m3inpt( objadd, z, nwcore )
      call m1time(-1,0 )

      if (ierr .ne. 0) return

      mimode = 1
      nname  = nb
      lrc    = lpi + m

      call misolv( mimode, 'Cold', m, n, nb, ne, nka, nname,
     $             iobj  , objadd,
     $             z(la),  z(lha), z(lka), z(lbl), z(lbu),
     $             z(lname1),   z(lname2),
     $             z(lhs), z(lxn), z(lpi), z(lrc),
     $             inform, ns    , z     , nwcore,
     $             ifuser, micore, majitn, minitn )

*     Print times for all clocks (if ltime > 0).

      call m1time( 0,2 )

*     end of minos3
      end
