/* This is a C main program written for a specific application by
   Minnie Ho, Dept of Electrical Engineering, Stanford University,
   July 1993.  It illustrates how to call subroutine minoss from C.

   This driver generates data for an optimization problem that
   has a nonlinear objective but only linear constraints.
   It calls Fortran subroutines mistart, mispec and minoss.
   Presumably subroutine funobj is supplied elsewhere to define
   the nonlinear objective.  (funobj is called by minoss.)

   17 Aug 2000: Modified to call new MINOS routines mistart, mispec.
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

/* Definition of constants I might want to change */

#define downcar 253
#define upcar    29
#define totcar  282       /* downcar+upcar */
#define ne      282       /* Number of non-zero elements in A */
#define ncons     2       /* Number of constraints */
#define nb (totcar+ncons) /* Total number of bounds on variables+slacks */
#define Emaxd   100.0     /* Max power in mW for any given downst carrier */
#define Emaxu    25.1189  /* Max power in mW for upstream */
#define nwcore 300000     /* Amount of 8-byte storage for MINOS */

/* External subroutines to be called */

extern mistart_(int*, int*, int*);
extern mispec_ (int*, int*);
extern minoss_ (char*, int*, int*, int*, int*, int*, int*, int*, int*,
                int*, double*, char*,
                double*, int*, int*, double*, double*, int*, int*,
                int*, double*, double*, double*,
                int*, int*, int*, int*, double*, double*,
                double*, int*);

main () {

   int dcar=downcar, ucar=upcar;
   int nvar=totcar;
   int i;
   int nprob = 1118;

/* Minoss input arguments */

   char*  start="Cold";
   char*  names;
   int    nwcore_ptr=nwcore, ncons_ptr=ncons, totcar_ptr=totcar;
   int    nnobj=totcar; 
   int    nb_ptr=nb, ne_ptr=ne, one=1, zero=0;
   int    ha[totcar], hs[nb];
   int    ka[totcar+1];
   double A[totcar], bl[nb], bu[nb], pi[ncons], xn[nb];
   double dzero=0.0;

/* Minoss output arguments */

   int    inform=0, mincor, ns, ninf;
   double rc[nb], sinf, obj, z[nwcore];
   
/* Minoss input and output files */

   int    ispecs=4, iprint=9, isumm=6, nout=6;

   printf ("Example use of MINOS from C\n");
   printf ("Call mistart\n"); fflush (stdout);
   mistart_( &iprint, &isumm, &ispecs );

   printf ("Call mispec \n"); fflush (stdout);
   mispec_( &ispecs, &inform );
   printf ("inform = %d\n", inform);

/* Set minoss arguments */

   names = malloc(40*sizeof(char));   /* 5 names, each 8 chars */

/* Initialize constraint matrix A,
   row indices ha, columns pointers ka.
   Set bounds bl and bu.
   Initialize the variables and slacks by 
   values (xn) and type (basic, etc) (hs). */

   printf ("Do some initializations\n");
   for (i=0; i<totcar; i++) {
       A[i]  = 1.0;
       ka[i] = i+1;
       bl[i] = 0.0;
       hs[i] = 2;
       if (i<upcar) {
          ha[i] = 1;
          bu[i] = Emaxu;
          xn[i] = Emaxu/(float) upcar;
       }
       else {
          ha[i] = 2;
          bu[i] = Emaxd;
          xn[i] = Emaxd/(float) downcar;
       }
   }
   ka[totcar] = totcar+1;

/* Bounds on slack variables */
   bl[totcar]   = bu[totcar]   = -Emaxd;
   bl[totcar+1] = bu[totcar+1] = -Emaxu;
   hs[totcar]   = hs[totcar+1] = 0;
   printf ("bounds\n");

   printf ("Ooooof\n");
   printf ("Calling fortran\n");
   minoss_( start, &ncons_ptr, &totcar_ptr, &nb_ptr, &ne_ptr, &one,
            &zero, &nnobj, &zero,
            &zero, &dzero, names,
            A, ha, ka, bl, bu, &zero, &zero,
            hs, xn, pi, rc,
            &inform, &mincor, &ns, &ninf, &sinf, &obj,
            z, &nwcore_ptr );
   printf ("Returned from fortran\n");
   printf ("inform is             %d\n", inform);
   printf ("ninf, sinf are        %d %d\n", ninf, sinf);
   printf ("Objective function is %e\n", obj);

}
/* End of main program */
