% 24 Mar 2014: dumpMPS.m derived from dumpLP.m.
%              Ding Ma and Michael Saunders, SOL, Stanford University.
% 29 Apr 2014: dumpMPS.m added to quadLP distribution.

modelNo = 5

switch modelNo
    %  case 0  % Josh's model from Dec 14  2010
    % load ../data/FBA/modelFinal.mat
    % mname = 'TMAfinal';
    % name  = 'TMAfinal.mps'

  case 1   % Josh's model    
    load ../data/FBA/model_final_build_unscaled.mat
    mname = 'TMA_ME';
    name  = 'TMA_ME.mps'   % TMA_ME_01.mps'

  case 2   % Ronan and Ines's data  
    load ../data/FBA/modelO.mat
    model = modelO;
    model.S = model.A;                %%%%%%%%% Special to this problem
    clear   modelO;
    mname = 'modelO';
    name  = 'modelO.mps'

% case 3   % Ronan and Ines's data
% load ~/Dropbox/linearfba/data/iAF1260_pathological_optPerturbation_matrix.mat
% This loads only A 9158x9158
% name  = 'iAF1260.mps'

  case 4   % Ronan and Ines's data
    load ../data/FBA/ModelGlcAer_WT.mat  % upper-case M
    model = modelGlcAer_WT;              % lower-case m
    clear   modelGlcAer_WT;
    mname = 'GlcAerWT'
    name  = 'GlcAerWT.mps'

  case 5   % Ronan and Ines's data with Yuekai's lifting
    load ../data/FBA/modelGlcAer_WTlift.mat % lower-case M
    model = modelGlcAer_WTchn;                           % lower-case m
    model.S = model.A;                %%%%%%%%% Special to this problem
    clear   modelGlcAer_WTchn;
    mname = 'GlcAlift';
    name  = 'GlcAlift.mps'

  case 6   % Ronan and Ines's data
    load ../data/FBA/10_01_27_ME_for_Michael.mat
    model = modelGlycAer_WT_Adj;
    clear   modelGlycAer_WT_Adj;
    mname = '10_01_ME';
    name  = '10_01_ME.mps'

  case 19  % Recon1
    load ../data/FBA/model_Recon1.mat
    model = model_Recon1;
    mname = 'Recon1'; 
    name  = 'Recon1.mps'

  % case 20  % ThMa
  %   load  data/model_ThMa.mat
  %   model = model_ThMa;
  %   mname = 'ThMa';
  %   name  = 'ThMa.mps';
    
  % case 21  % GlcAer
  %   load  data/model_GlcAer.mat
  %   model = model_GlcAer;
  %   mname = 'GlcAer';
  %   name  = 'GlcAer.mps';

  otherwise
    disp('Unknown modelNo')
end

S      = model.S;
b      = model.b;
c      = model.c;
xl     = model.lb;
xu     = model.ub;

[m,n]   = size(S);
if isfield(model,'csense')
    csense = model.csense;      % E or L or G
else
    csense(1:m,1) = 'E';
end

if isfield(model,'osense')
    osense = model.osense;      % 1=min   (-1=max ?)
else
    osense = 1;
end

if modelNo==5
    osense  = 1;            %%%%%%%%% Special to this problem!
end

% 06 Aug 2012: Include c as an additional free *last* row of Ax = b
%              so that SQOPT will treat the problem as an LP, not a QP.


S     = [      S            % Luckily we only have to do it once
         osense*sparse(c)'];
b     = [b; 0];
csense(m+1,1) = 'N';

[m,n]  = size(S)
bigbnd = 1e+20;                % MINOS and SQOPT's "infinite" bound

%nzS     = nnz(S)
%[I,J,V] = find(S);          % Sij indices and values

% Generate dummy row name and column names

rname(1:m,1:8) = ' ';
rname(1:m,1)   = 'r';
for i=1:m
   rname(i,2:8) = sprintf('%7g', i);
end

cname(1:n,1:8) = ' ';
cname(1:n,1)   = 'x';
for j=1:n
   cname(j,2:8) = sprintf('%7g', j);
end


tic
fid = fopen(name,'w');         % Open file "name" for writing
% fprintf(fid,'%8i\n'    , m)    % No of rows in S (including obj row)
% fprintf(fid,'%8i\n'    , n)    % No of cols in S
% fprintf(fid,'%8i\n'    , nzS)  % No of nonzeros
% fprintf(fid,'%8i\n'    , P)    % Pointers         n+1
% fprintf(fid,'%8i\n'    , I)    % Row indices      nzS
% fprintf(fid,'%19.12e\n', V)    % Values           nzS

fprintf(fid,'NAME          %c%c%c%c%c%c%c%c', mname);
fprintf(fid,'\n');   % Has to be separate from previous line

fprintf(fid,'ROWS\n');
for i=1:m
    fprintf(fid,'  %c %c%c%c%c%c%c%c%c\n', csense(i),rname(i,:));
end

fprintf(fid,'COLUMNS\n');
for j=1:n
   c = S(:,j);
   [I,J,V] = find(c);
   for k=1:length(I);
      i = I(k);
      fprintf(fid,'    %c%c%c%c%c%c%c%c  %c%c%c%c%c%c%c%c  %12.5e\n', ...
                        cname(j,:),        rname(i,:),        V(k));
   end
end

fprintf(fid,'RHS\n');
[I,J,V] = find(b);
for k=1:length(I)
   i = I(k);
   fprintf(fid, '    RHS       %c%c%c%c%c%c%c%c  %12.5e\n', ...
                               rname(i,:),         b(i));
end

fprintf(fid,'BOUNDS\n');
for j=1:n
  if xl(j) ~= 0.0
     fprintf(fid, ' LO BND       %c%c%c%c%c%c%c%c  %12.5e\n', ...
                                 cname(j,:),         xl(j));
  end
  if xu(j) < bigbnd
     fprintf(fid, ' UP BND       %c%c%c%c%c%c%c%c  %12.5e\n', ...
                                 cname(j,:),         xu(j));
  end
end

fprintf(fid,'ENDATA\n');
fclose(fid);
toc
