*     ------------------------------------------------------------------
*     File minosm.for
*     This is a main program to test subroutine mirmps, which is
*     part of MINOS 5.5.  It uses mirmps to read the MPS file
*     associated with problem t4manne, then asks minoss to solve it.
*
*     
*     19 Apr 1992: First version, derived from minost.for.
*     24 Oct 1996: Test miwmps also.
*     20 Aug 2000: mimps, mpsout renamed mirmps, miwmps.
*                  Adapted to use new mistart, mispec.
*     ------------------------------------------------------------------

      program            minosm

      implicit           real(16) (a-h,o-z)

      parameter        ( maxm   = 1000,
     $                   maxn   = 2000,
     $                   maxnb  = maxm + maxn,
     $                   maxne  = 20000,
     $                   maxnam = maxnb )

      character*8        names(5)
      integer*4          ha(maxne) , hint(maxn)   , hs(maxnb)
      integer            ka(maxn+1), name1(maxnam), name2(maxnam)
      real(16)           a(maxne)  , bl(maxnb)    , bu(maxnb),
     $                   xn(maxnb) , pi(maxm)     , rc(maxnb)

      parameter          ( lenz = 100000 )
      real(16)           z(lenz)
*     ------------------------------------------------------------------

!     Specify some file numbers.  (Others may be in the SPECS file.)
!     0 means that there should be no file.

      iprint = 9   ! The MINOS PRINT   file.
      isumm  = 6   ! The MINOS SUMMARY file.
      ispecs = 4   ! The MINOS SPECS   file.
      nout   = 6   ! Local output file (> 0).

      open( iprint, file='minosm.out', status='UNKNOWN')
      open( ispecs, file='minosm.spc', status='OLD')

!     Open the specified MINOS files.
!     mistart MUST BE CALLED BEFORE ANY OTHER MINOS ROUTINE.

      call mistart( iprint, isumm, ispecs )

!     Read the SPECS file  (if any -- it's OK if ispecs = 0).

      call mispec( ispecs, inform )

      if (inform .ge. 2) then
         write(nout, *) 'ispecs > 0 but no Specs file found'
         stop
      end if

*     ------------------------------------------------------------------
*     Read an MPS file from unit imps.
*     File imps should be opened here if necessary.
*     nncon, nnjac, nnobj  must be defined by now.
*     For linear programs they would all be zero.
*     We hardwire them here for problem t4manne as
*        nncon  = 10
*        nnjac  = 10
*        nnobj  = 20
*     Alternatively, they could be defined in the SPECS file via
*        Nonlinear constraints           10
*        Nonlinear Jacobian  variables   10
*        Nonlinear objective variables   20
*     but then we would need the MINOS common blocks
*     common    /m7len / fobj  ,fobj2 ,nnobj ,nnobj0
*     common    /m8len / njac  ,nncon ,nncon0,nnjac
*     in this program to make them accessible in "call mirmps( ... )".
*
*     NOTE: Jacobian Sparse or Dense must also be defined.
*     It could be in the SPECS file.
*     For safety (and as an example) we set it here.
*     ------------------------------------------------------------------
      nncon  = 10
      nnjac  = 10
      nnobj  = 20
      imps   = 10
      open( unit=imps, file='t4manne.mps', status='OLD' )
      call miopt ( 'Jacobian  Sparse', 0, 0, inform )

*     mirmps will load names(1) with the problem name from the MPS file.
*     Here we can load names(2)-names(5) with the desired 8-character
*     Objective, Rhs, Ranges and Bounds names.
*     Blank means grab the first names encountered in the MPS file.

      names(2) = 'funobj'
      names(3) = ' '
      names(4) = ' '
      names(5) = ' '
      nwcore   = lenz

      call mirmps( imps, maxm, maxn, maxnb, maxne,
     $             nncon, nnjac, nnobj,
     $             m, n, nb, ne, nint,
     $             iobj, objadd, names,
     $             a, ha, ka, bl, bu, name1, name2,
     $             hint, hs, xn, pi,
     $             inform, ns, z, nwcore )

      if (inform .ge. 1) then
         write(nout, *) 'Error while reading MPS file from unit', imps
         stop
      end if             

      if (nint   .gt. 0) then
         write(nout, *) 'No. of integer variables:', nint
      end if

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     mirmps has already initialized hs(*) and xn(*).
*     Also, the MPS file may have initialized them via an INITIAL
*     bounds set.  If necessary, they can be further modified here.
*
*     For cold starts, the first n entries of hs should be
*     0, 1, 2, 3, 4, or 5.  The values are used by the Crash procedure
*     to choose an initial basis B.
*     If hs(j) = 0 or 1, column j is eligible for B.
*     If hs(j) = 2,      column j is initially superbasic (not in B).
*     If hs(j) = 3,      column j is eligible for B and is given
*                        preference over columns with hs(j) = 0 or 1.
*     If hs(j) = 4 or 5, column j is initially nonbasic.
*     ------------------------------------------------------------------
      nname  = nb
      call minoss( 'Cold', m, n, nb, ne, nname,
     $             nncon, nnobj, nnjac,
     $             iobj, objadd, names,
     $             a, ha, ka, bl, bu, name1, name2,
     $             hs, xn, pi, rc, 
     $             inform, mincor, ns, ninf, sinf, obj,
     $             z, nwcore )

      write(nout, *) ' '
      write(nout, *) 'minoss finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'ninf   =', ninf
      write(nout, *) 'sinf   =', sinf
      write(nout, *) 'obj    =', obj

*     ------------------------------------------------------------------
*     Test miwmps by outputting the current problem.
*     ------------------------------------------------------------------
      imps   = 30
      write(nout, *) ' '
      write(nout, *) 'Writing MPS file to unit', imps
      open( unit=imps, file='minosm.mps', status='UNKNOWN' )

      call miwmps( imps, m, n, nb, ne, nname, names,
     $             a, ha, ka, bl, bu, name1, name2 )

      write(nout, *) 'MPS file written'

      end ! program minosm ! (for testing mirmps and miwmps)
